{
 -------------------------------------------------------------------------
 Copyright (C) 1998-2003 Hger+Busch                   / >>>>>>>>> /-----
 Ingenieurbuero fuer Kommunikationslsungen           / <<<<<<<<< /
 ----------------------------------------------------/ >>>>>>>>> /
 All rights reserved.
                                                    http://www.commso.com

 Project     : hbTapi Components
 Modul       : Sample v1.

 Description : This sample shows how to use the "Digits" features of a
               line device.

 History     : [-] Fixed [+] Added [*] Improved

 01/01/03   Creation
}
unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, hbTAPI, Tapi, Buttons, ExtCtrls;

type
  TForm1 = class(TForm)
    ListBox1: TListBox;
    GroupBox_MonitorDigits: TGroupBox;
    GroupBox_GatherDigits: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit2: TEdit;
    Edit_Termdigits: TEdit;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    GroupBox_GenerateDigits: TGroupBox;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    GroupBox4: TGroupBox;
    LabelDevice: TLabel;
    Label1: TLabel;
    ComboBoxDevice: TComboBox;
    Label3: TLabel;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    SpeedButton6: TSpeedButton;
    SpeedButton7: TSpeedButton;
    SpeedButton8: TSpeedButton;
    SpeedButton9: TSpeedButton;
    SpeedButton10: TSpeedButton;
    SpeedButton11: TSpeedButton;
    SpeedButton12: TSpeedButton;
    SpeedButton16: TSpeedButton;
    SpeedButton17: TSpeedButton;
    SpeedButton18: TSpeedButton;
    SpeedButton19: TSpeedButton;
    GroupBox_GenerateTone: TGroupBox;
    GroupBox5: TGroupBox;
    Edit1: TEdit;
    Button1: TButton;
    Button_Beep: TButton;
    Button3: TButton;
    Button2: TButton;
    Button_Ringback: TButton;
    Label2: TLabel;
    TapiLine1: TTapiLine;
    CheckBox_DTMF2: TCheckBox;
    CheckBox_Pulse2: TCheckBox;
    Label11: TLabel;
    CheckBox_DTMF1: TCheckBox;
    CheckBox_Pulse1: TCheckBox;
    RadioButton_DTMF: TRadioButton;
    RadioButton_Pulse: TRadioButton;
    Panel1: TPanel;
    Label12: TLabel;
    GroupBox_MonitorSilence: TGroupBox;
    CheckBox_MonitorSilence: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure ComboBoxDeviceChange(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure TapiLine1Connected(Sender: TTapiLine; Call: TTapiCall);
    procedure TapiLine1Digit(Sender: TTapiLine; Call: TTapiCall; Digit: Char);
    procedure DoGatherDigits(Sender: TObject);
    procedure TapiLine1GatherDigits(Sender: TTapiLine; Call: TTapiCall;
      Digits: String; Termination: Cardinal);
    procedure DoMonitorDigits(Sender: TObject);
    procedure TapiLine1Offering(Sender: TTapiLine; Call: TTapiCall);
    procedure DoGenearteDigit(Sender: TObject);
    procedure Button_BeepClick(Sender: TObject);
    procedure ListBox1DblClick(Sender: TObject);
    procedure TapiLine1Silence(Sender: TTapiLine; Call: TTapiCall);
  private
    procedure UpdateStatus;
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  // Fill in the list box with all available telephony devices
  ComboBoxDevice.Items.assign(Tapiline1.DeviceList);
{$IFDEF HBTAPIEDT_PRO}
  Edit2.Text := IntToStr(TapiLine1.CallOptions.GatherDigits.NumDigits);
{$ENDIF}
end;

procedure TForm1.ComboBoxDeviceChange(Sender: TObject);
begin
  Label1.Caption := '';

  // If TapiLine is currently open then close it
  TapiLine1.Active := False;

  // Set TapiLine to use the device selected in the list box
  TapiLine1.DeviceID := ComboBoxDevice.ItemIndex;

  // If there was a problem opening etLine last time then make sure that the
  // following properties are reset to their default.
  TapiLine1.Privileges.Monitor := True;
  TapiLine1.Privileges.Owner   := True;

  try
    TapiLine1.Active := True;
    Listbox1.items.add('Device is active (open)');
  except
    on E:ETapiError do
    begin
      if (E.ErrorCode = LINEERR_INVALMEDIAMODE) then
      begin
        TapiLine1.Privileges.Owner := False;
        try
          TapiLine1.Active := True;
          Listbox1.items.add('Device is active (open)');
        except
          on E:ETapiError do
            MessageDlg('Error opening line device: ' + E.Message, mtError, [mbOk],0);
        end;
        Listbox1.items.add('This device is not 100% TAPI compliant');
      end
      else
      begin
        MessageDlg('Error opening line device: ' + E.Message, mtError, [mbOk],0);
        Listbox1.items.add(E.Message);
      end;
    end;
  end;
  UpdateStatus;
end;

procedure TForm1.UpdateStatus;
var dwCallFeatures : DWord;
begin
  // if the line device is available there must be at least one address we can
  // use to check the availability of CallFeatures
  if TapiLine1.Available then
    dwCallFeatures := TapiLine1.Addresses[0].Caps.CallFeatures
  else
    dwCallFeatures := 0;

  if dwCallFeatures and LINECALLFEATURE_MONITORDIGITS > 0 then
  begin
    GroupBox_MonitorDigits.Enabled := TRUE;
    GroupBox_MonitorDigits.Caption := 'Monitor Digits (Available)';
  end
  else
  begin
    GroupBox_MonitorDigits.Enabled := FALSE;
    GroupBox_MonitorDigits.Caption := 'Generate Tone'
  end;

  if (dwCallFeatures and LINECALLFEATURE_GATHERDIGITS > 0) then
  begin
    GroupBox_GatherDigits.Enabled := TRUE;
    GroupBox_GatherDigits.Caption := 'Gather Digits (Available)';
  end
  else
  begin
    GroupBox_GatherDigits.Enabled := FALSE;
    GroupBox_GatherDigits.Caption := 'Gather Digits'
  end;

  if (dwCallFeatures and LINECALLFEATURE_MONITORTONES > 0) then
  begin
    GroupBox_MonitorSilence.Enabled := TRUE;
    GroupBox_MonitorSilence.Caption := 'Monitor Silence (Available)';
  end
  else
  begin
    GroupBox_MonitorSilence.Enabled := FALSE;
    GroupBox_MonitorSilence.Caption := 'Monitor Silence';
  end;

  if dwCallFeatures and LINECALLFEATURE_GENERATETONE > 0 then
  begin
    GroupBox_GenerateTone.Enabled := TRUE;
    GroupBox_GenerateTone.Caption := 'Generate Tone (Available)';
  end
  else
  begin
    GroupBox_GenerateTone.Enabled := FALSE;
    GroupBox_GenerateTone.Caption := 'Generate Tone'
  end;

  if dwCallFeatures and LINECALLFEATURE_GENERATEDIGITS > 0 then
  begin
    GroupBox_GenerateDigits.Enabled := TRUE;
    GroupBox_GenerateDigits.Caption := 'Generate Digits (Available)';
  end
  else
  begin
    GroupBox_GenerateDigits.Enabled := FALSE;
    GroupBox_GenerateDigits.Caption := 'Generate Digits';
  end;


  if (dwCallFeatures and LINECALLFEATURE_MONITORDIGITS > 0) then
  begin
    GroupBox_MonitorDigits.Enabled := TRUE;
    GroupBox_MonitorDigits.Caption := 'Monitor Digits (Available)'
  end
  else
  begin
    GroupBox_MonitorDigits.Enabled := FALSE;
    GroupBox_MonitorDigits.Caption := 'Monitor Digits'
  end;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  TapiLine1.MakeCall(Edit1.Text);
end;

procedure TForm1.TapiLine1Connected(Sender: TTapiLine; Call: TTapiCall);
begin
  ListBox1.Items.Add('Connected call available');

{$IFDEF HBTAPIEDT_PRO}
  if CheckBox1.Checked then
    Call.MonitorDigits.Active := True;
{$ENDIF}
  if TapiLine1.WaveIn.Available then
    ListBox1.Items.Add(Format('TapiLine WaveIn DeviceID = %d',[TapiLine1.WaveIn.DeviceID]))
  else
    ListBox1.Items.Add(Format('TapiLine WaveIn DeviceID = n/a',[]))
end;

procedure TForm1.TapiLine1Digit(Sender: TTapiLine; Call: TTapiCall; Digit: Char);
begin
  ListBox1.Items.Add('Digit received: ' + Digit);
end;

procedure TForm1.DoGatherDigits(Sender: TObject);
begin
{$IFDEF HBTAPIEDT_PRO}
  if TapiLine1.Calls.Count = 0 then exit;
  CheckBox2.OnClick := nil;
  try
    if CheckBox2.Checked then
    begin
      TapiLine1.Calls[0].GatherDigits.NumDigits := StrToIntDef(Edit2.Text,0);
      TapiLine1.Calls[0].GatherDigits.DigitModes := 0;
      if CheckBox_DTMF2.Checked then
        TapiLine1.Calls[0].GatherDigits.DigitModes := TapiLine1.Calls[0].GatherDigits.DigitModes or LINEDIGITMODE_DTMF;
      if CheckBox_Pulse2.Checked then
        TapiLine1.Calls[0].GatherDigits.DigitModes := TapiLine1.Calls[0].GatherDigits.DigitModes or LINEDIGITMODE_PULSE;
      TapiLine1.Calls[0].GatherDigits.TerminationDigits := Edit_Termdigits.Text;
      TapiLine1.Calls[0].GatherDigits.Active := True;
      ListBox1.Items.Add('Gathering started');
    end
    else if (not CheckBox2.Checked) and (TapiLine1.Calls.Count > 0) then
    begin
      TapiLine1.Calls[0].GatherDigits.Active := False;
    end;
  finally
    CheckBox2.Checked := TapiLine1.Calls[0].GatherDigits.Active;
    CheckBox2.OnClick := DoGatherDigits;
  end;
{$ELSE}
  MessageDlg('GatherDigits is a feature of the Professional Edition', mtInformation, [mbok], 0);
{$ENDIF}
end;

procedure TForm1.TapiLine1GatherDigits(Sender: TTapiLine; Call: TTapiCall;
  Digits: String; Termination: Cardinal);
begin
  ListBox1.Items.Add('Gathering terminated');
  case Termination of
    LINEGATHERTERM_BUFFERFULL : // The requested number of digits has been gathered. The buffer is full.
      ListBox1.Items.Add('Digits gathered: ' + Digits);
    LINEGATHERTERM_CANCEL : // The request was canceled by this application, by another application, or because the call terminated.
      ListBox1.Items.Add('Gathering canceled');
    LINEGATHERTERM_FIRSTTIMEOUT : // The first digit timeout expired. The buffer contains no digits.
      ListBox1.Items.Add('first digit timeout');
    LINEGATHERTERM_INTERTIMEOUT : // The inter-digit timeout expired. The buffer contains at least one digit.
      ListBox1.Items.Add('inter-digit timeout');
    LINEGATHERTERM_TERMDIGIT :
      ListBox1.Items.Add('Termination digit received ('+Digits+')'); // One of the termination digits matched a received digit. The matched termination digit is the last digit in the buffer.
  end;
  CheckBox2.OnClick := nil;
  CheckBox2.Checked := False;
  CheckBox2.OnClick := DoGatherDigits;
end;

procedure TForm1.DoMonitorDigits(Sender: TObject);
begin
{$IFDEF HBTAPIEDT_PRO}
  if TapiLine1.Calls.Count = 0 then exit;
  CheckBox1.OnClick := nil;
  try
    if CheckBox1.Checked then
    begin
      if CheckBox_DTMF1.Checked then
        TapiLine1.Calls[0].MonitorDigits.DigitModes := LINEDIGITMODE_DTMF;
      if CheckBox_Pulse1.Checked then
        TapiLine1.Calls[0].MonitorDigits.DigitModes := TapiLine1.Calls[0].MonitorDigits.DigitModes or LINEDIGITMODE_PULSE;
      TapiLine1.Calls[0].MonitorDigits.Active := True;
      ListBox1.Items.Add('MonitorDigits active');
    end
    else
    begin
      TapiLine1.Calls[0].MonitorDigits.Active := False;
      ListBox1.Items.Add('MonitorDigits inactive');
    end;
  finally
    CheckBox1.Checked := TapiLine1.Calls[0].MonitorDigits.Active;
    CheckBox1.OnClick := DoMonitorDigits;
  end;
{$ELSE}
  MessageDlg('MonitorDigits is a feature of the Professional Edition', mtInformation, [mbok], 0);
{$ENDIF}
end;

procedure TForm1.TapiLine1Offering(Sender: TTapiLine; Call: TTapiCall);
begin
  Call.Answer;
end;

procedure TForm1.DoGenearteDigit(Sender: TObject);
begin
{$IFDEF HBTAPIEDT_PRO}
  if TapiLine1.Calls.Count = 0 then exit;
  if TapiLine1.Calls.Count > 0 then
  begin
    if RadioButton_DTMF.Checked then
      TapiLine1.Calls[0].GenerateDigits(TSpeedButton(Sender).Caption, 100)
    else
      TapiLine1.Calls[0].GeneratePulseDigits(TSpeedButton(Sender).Caption, 100);
  end;
{$ELSE}
  MessageDlg('GenerateDigits and GeneratePulseDigits are features of the Professional Edition', mtInformation, [mbok], 0);
{$ENDIF}
end;

procedure TForm1.Button_BeepClick(Sender: TObject);
begin
{$IFDEF HBTAPIEDT_ENT}
  if TapiLine1.Calls.Count > 0 then
  begin
    case TSpeedButton(Sender).Tag of
    0: TapiLine1.Calls[0].GenerateTone(LINETONEMODE_BEEP, 1000);
    1: TapiLine1.Calls[0].GenerateTone(LINETONEMODE_BUSY, 1000);
    2: TapiLine1.Calls[0].GenerateTone(LINETONEMODE_BILLING, 1000);
    3: TapiLine1.Calls[0].GenerateTone(LINETONEMODE_RINGBACK, 1000);
    end;
  end;
{$ELSE}
  MessageDlg('GenerateTone is a feature of the Enterprise Edition', mtInformation, [mbok], 0);
{$ENDIF}
end;

procedure TForm1.ListBox1DblClick(Sender: TObject);
begin
  ListBox1.Items.Clear;
end;

procedure TForm1.TapiLine1Silence(Sender: TTapiLine; Call: TTapiCall);
begin
  ListBox1.Items.Add('Silence detected');
end;

end.
